<?php

use Devmonsta\Libs\Taxonomies;

class Category extends Taxonomies
{

    public function register_controls()
    {

        $this->add_control( [
            'name'     => 'category_color',
            'type'     => 'color-picker',
            'label'    => esc_html__( 'Text Color', 'qoxag' ),
            'desc'     => esc_html__( 'Text color of this category', 'qoxag' ),
            'value'    => '',
            'palettes' => ['#ba4e4e', '#0ce9ed', '#941940'],
        ] );

        $this->add_control( [
            'name'     => 'category_bg_color',
            'type'     => 'color-picker',
            'label'    => esc_html__( 'Background Color', 'qoxag' ),
            'desc'     => esc_html__( 'Background color of this category', 'qoxag' ),
            'value'    => '',
            'palettes' => ['#ba4e4e', '#0ce9ed', '#941940'],
        ] );

        $this->add_control( [
            'name'     => 'category_image',
            'type'     => 'upload',
            'label'    => esc_html__( 'Category Image', 'qoxag' ),
            'desc'     => esc_html__( 'Category Image of this category', 'qoxag' ),
        ] );

        $this->add_control( [
            'type'         => 'switcher',
            'name'         => 'category_layout_overwrite',
            'value'        => 'no',
            'label'        => esc_html__( 'Overwrite Layout', 'qoxag' ),
            'desc'         => esc_html__( 'It will orvewrite the customize settings category layout', 'qoxag' ),
            'left-choice'  => [
                'no' => esc_html__( 'No', 'qoxag' ),
            ],
            'right-choice' => [
                'yes' => esc_html__( 'Yes', 'qoxag' ),
            ],
        ] );

        $this->add_control( [
            'name'    => 'qoxag_single_category_layout',
            'id'      => 'qoxag_single_category_layout',
            'type'    => 'image-picker',
            'value'   => 'style1',
            'attr'    => [
                'class'    => 'custom-class',
                'data-foo' => 'bar',
            ],
            'label'   => esc_html__( 'Category Layout', 'qoxag' ),
            'desc'    => esc_html__( 'Select category layout', 'qoxag' ),
            'choices' => [
                'style1' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min1.png',
                ],
                'style2' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style3' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style4' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style5' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style6' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_min2.png',
                ],
                'style7' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/category/category_7.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/category/category_7.png',
                ],
            ],
            'conditions' => [
                [
                    'control_name' => 'category_layout_overwrite',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ] );
    }
}
